# Fichier de librairie.
# Classe de definition d'une fenetre d'affichage d'un graphique avec mise a jour de son contenue a la volé.
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.animation as animation
class GraphiqueTempsReel:
    def __init__(self,nomFenetre=None,titreFigure=None,legendeAxeX=None,legendeAxeY=None,legendeVoie1=None,legendeVoie2=None,nombrePointSurX=250,yMin=0,yMax=1):
        self.fig, self.ax = plt.subplots()
        self.plotbuffer = [0] * nombrePointSurX
        self.line, = self.ax.plot(self.plotbuffer,marker='+')
        if nomFenetre != None :
            self.fig.canvas.set_window_title(nomFenetre)
        self.ax.set_ylim(yMin,yMax)
        self.nombrePointSurX = nombrePointSurX
        self.xLegendTicks = []
        self.xLegendTickLabel = []
        for i in range(6):
            self.xLegendTicks.append( i * (nombrePointSurX/5) )
            self.xLegendTickLabel.append( self.xLegendTicks[-1] - nombrePointSurX )
        self.ax.set_xticks(self.xLegendTicks)
        self.ax.set_xticklabels(self.xLegendTickLabel)
        self.ringbuffer = []
        self.ani = animation.FuncAnimation(self.fig, self.update, interval=50)
        if titreFigure != None : plt.title(titreFigure)
        if legendeAxeX != None : plt.xlabel(legendeAxeX)
        if legendeAxeY != None : plt.ylabel(legendeAxeY)
        self.ringbuffer2 = None
        if legendeVoie2 != None :
            self.plotbuffer2 = [0] * nombrePointSurX
            self.line2, = self.ax.plot(self.plotbuffer2,marker='*')
            self.ringbuffer2 = []
            self.ax.legend([legendeVoie1,legendeVoie2])
        else :
            if legendeVoie1 != None : self.ax.legend([legendeVoie1])        
    def update(self, data):
        self.plotbuffer = np.append(self.plotbuffer, self.ringbuffer)
        self.plotbuffer = self.plotbuffer[-self.nombrePointSurX:]
        self.ringbuffer = []
        self.line.set_ydata(self.plotbuffer)
        if self.ringbuffer2 != None :
            self.plotbuffer2 = np.append(self.plotbuffer2, self.ringbuffer2)
            self.plotbuffer2 = self.plotbuffer2[-self.nombrePointSurX:]
            self.ringbuffer2 = []
            self.line2.set_ydata(self.plotbuffer2)
            return [ self.line , self.line2 ]
        else :        
            return self.line
    def ajouterDonnee(self, v , v2=None):        
        self.ringbuffer.append(v)
        if self.ringbuffer2 != None :
            if v2 != None : self.ringbuffer2.append(v2)
            else : self.ringbuffer2.append(0)        
        xLegendTickLabelCpy = []
        for i in range(6):
            self.xLegendTickLabel[i] += 1
            if self.xLegendTickLabel[i] < 0 : xLegendTickLabelCpy.append(None)
            else : xLegendTickLabelCpy.append( self.xLegendTickLabel[i] )
        self.ax.set_xticklabels(xLegendTickLabelCpy)
    def afficher(self):
        plt.show()
